/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.ServiceTasksClient;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectTaskInner;
import com.azure.resourcemanager.datamigration.implementation.ProjectTaskImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.ProjectTask;
import com.azure.resourcemanager.datamigration.models.ServiceTasks;

public final class ServiceTasksImpl
implements ServiceTasks {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceTasksImpl.class);
    private final ServiceTasksClient innerClient;
    private final DataMigrationManager serviceManager;

    public ServiceTasksImpl(ServiceTasksClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProjectTask> list(String groupName, String serviceName) {
        PagedIterable<ProjectTaskInner> inner = this.serviceClient().list(groupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectTaskImpl((ProjectTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProjectTask> list(String groupName, String serviceName, String taskType, Context context) {
        PagedIterable<ProjectTaskInner> inner = this.serviceClient().list(groupName, serviceName, taskType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectTaskImpl((ProjectTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProjectTask> createOrUpdateWithResponse(String groupName, String serviceName, String taskName, ProjectTaskInner parameters, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().createOrUpdateWithResponse(groupName, serviceName, taskName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask createOrUpdate(String groupName, String serviceName, String taskName, ProjectTaskInner parameters) {
        ProjectTaskInner inner = this.serviceClient().createOrUpdate(groupName, serviceName, taskName, parameters);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ProjectTask> getWithResponse(String groupName, String serviceName, String taskName, String expand, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().getWithResponse(groupName, serviceName, taskName, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask get(String groupName, String serviceName, String taskName) {
        ProjectTaskInner inner = this.serviceClient().get(groupName, serviceName, taskName);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String groupName, String serviceName, String taskName, Boolean deleteRunningTasks, Context context) {
        return this.serviceClient().deleteWithResponse(groupName, serviceName, taskName, deleteRunningTasks, context);
    }

    @Override
    public void delete(String groupName, String serviceName, String taskName) {
        this.serviceClient().delete(groupName, serviceName, taskName);
    }

    @Override
    public Response<ProjectTask> updateWithResponse(String groupName, String serviceName, String taskName, ProjectTaskInner parameters, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().updateWithResponse(groupName, serviceName, taskName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask update(String groupName, String serviceName, String taskName, ProjectTaskInner parameters) {
        ProjectTaskInner inner = this.serviceClient().update(groupName, serviceName, taskName, parameters);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ProjectTask> cancelWithResponse(String groupName, String serviceName, String taskName, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().cancelWithResponse(groupName, serviceName, taskName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask cancel(String groupName, String serviceName, String taskName) {
        ProjectTaskInner inner = this.serviceClient().cancel(groupName, serviceName, taskName);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    private ServiceTasksClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }
}

