/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.ProjectsClient;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectInner;
import com.azure.resourcemanager.datamigration.implementation.ProjectImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.Project;
import com.azure.resourcemanager.datamigration.models.Projects;

public final class ProjectsImpl
implements Projects {
    private static final ClientLogger LOGGER = new ClientLogger(ProjectsImpl.class);
    private final ProjectsClient innerClient;
    private final DataMigrationManager serviceManager;

    public ProjectsImpl(ProjectsClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Project> list(String groupName, String serviceName) {
        PagedIterable<ProjectInner> inner = this.serviceClient().list(groupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectImpl((ProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Project> list(String groupName, String serviceName, Context context) {
        PagedIterable<ProjectInner> inner = this.serviceClient().list(groupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectImpl((ProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Project> getWithResponse(String groupName, String serviceName, String projectName, Context context) {
        Response<ProjectInner> inner = this.serviceClient().getWithResponse(groupName, serviceName, projectName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectImpl((ProjectInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Project get(String groupName, String serviceName, String projectName) {
        ProjectInner inner = this.serviceClient().get(groupName, serviceName, projectName);
        if (inner != null) {
            return new ProjectImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String groupName, String serviceName, String projectName, Boolean deleteRunningTasks, Context context) {
        return this.serviceClient().deleteWithResponse(groupName, serviceName, projectName, deleteRunningTasks, context);
    }

    @Override
    public void delete(String groupName, String serviceName, String projectName) {
        this.serviceClient().delete(groupName, serviceName, projectName);
    }

    @Override
    public Project getById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return (Project)this.getWithResponse(groupName, serviceName, projectName, Context.NONE).getValue();
    }

    @Override
    public Response<Project> getByIdWithResponse(String id, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return this.getWithResponse(groupName, serviceName, projectName, context);
    }

    @Override
    public void deleteById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        Boolean localDeleteRunningTasks = null;
        this.deleteWithResponse(groupName, serviceName, projectName, localDeleteRunningTasks, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Boolean deleteRunningTasks, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return this.deleteWithResponse(groupName, serviceName, projectName, deleteRunningTasks, context);
    }

    private ProjectsClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectImpl define(String name) {
        return new ProjectImpl(name, this.manager());
    }
}

