/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseInfo;
import com.azure.resourcemanager.datamigration.models.Project;
import com.azure.resourcemanager.datamigration.models.ProjectProvisioningState;
import com.azure.resourcemanager.datamigration.models.ProjectSourcePlatform;
import com.azure.resourcemanager.datamigration.models.ProjectTargetPlatform;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ProjectImpl
implements Project,
Project.Definition,
Project.Update {
    private ProjectInner innerObject;
    private final DataMigrationManager serviceManager;
    private String groupName;
    private String serviceName;
    private String projectName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProjectSourcePlatform sourcePlatform() {
        return this.innerModel().sourcePlatform();
    }

    @Override
    public AzureActiveDirectoryApp azureAuthenticationInfo() {
        return this.innerModel().azureAuthenticationInfo();
    }

    @Override
    public ProjectTargetPlatform targetPlatform() {
        return this.innerModel().targetPlatform();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public ConnectionInfo sourceConnectionInfo() {
        return this.innerModel().sourceConnectionInfo();
    }

    @Override
    public ConnectionInfo targetConnectionInfo() {
        return this.innerModel().targetConnectionInfo();
    }

    @Override
    public List<DatabaseInfo> databasesInfo() {
        List<DatabaseInfo> inner = this.innerModel().databasesInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProjectProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.groupName;
    }

    @Override
    public ProjectInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectImpl withExistingService(String groupName, String serviceName) {
        this.groupName = groupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public Project create() {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Project create(Context context) {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new ProjectInner();
        this.serviceManager = serviceManager;
        this.projectName = name;
    }

    @Override
    public ProjectImpl update() {
        return this;
    }

    @Override
    public Project apply() {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Project apply(Context context) {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectImpl(ProjectInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.groupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
    }

    @Override
    public Project refresh() {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().getWithResponse(this.groupName, this.serviceName, this.projectName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Project refresh(Context context) {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().getWithResponse(this.groupName, this.serviceName, this.projectName, context).getValue());
        return this;
    }

    @Override
    public ProjectImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ProjectImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ProjectImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ProjectImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ProjectImpl withSourcePlatform(ProjectSourcePlatform sourcePlatform) {
        this.innerModel().withSourcePlatform(sourcePlatform);
        return this;
    }

    @Override
    public ProjectImpl withAzureAuthenticationInfo(AzureActiveDirectoryApp azureAuthenticationInfo) {
        this.innerModel().withAzureAuthenticationInfo(azureAuthenticationInfo);
        return this;
    }

    @Override
    public ProjectImpl withTargetPlatform(ProjectTargetPlatform targetPlatform) {
        this.innerModel().withTargetPlatform(targetPlatform);
        return this;
    }

    @Override
    public ProjectImpl withSourceConnectionInfo(ConnectionInfo sourceConnectionInfo) {
        this.innerModel().withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public ProjectImpl withTargetConnectionInfo(ConnectionInfo targetConnectionInfo) {
        this.innerModel().withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public ProjectImpl withDatabasesInfo(List<DatabaseInfo> databasesInfo) {
        this.innerModel().withDatabasesInfo(databasesInfo);
        return this;
    }
}

