/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.FilesClient;
import com.azure.resourcemanager.datamigration.fluent.models.FileStorageInfoInner;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectFileInner;
import com.azure.resourcemanager.datamigration.implementation.FileStorageInfoImpl;
import com.azure.resourcemanager.datamigration.implementation.ProjectFileImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.FileStorageInfo;
import com.azure.resourcemanager.datamigration.models.Files;
import com.azure.resourcemanager.datamigration.models.ProjectFile;

public final class FilesImpl
implements Files {
    private static final ClientLogger LOGGER = new ClientLogger(FilesImpl.class);
    private final FilesClient innerClient;
    private final DataMigrationManager serviceManager;

    public FilesImpl(FilesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProjectFile> list(String groupName, String serviceName, String projectName) {
        PagedIterable<ProjectFileInner> inner = this.serviceClient().list(groupName, serviceName, projectName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectFileImpl((ProjectFileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProjectFile> list(String groupName, String serviceName, String projectName, Context context) {
        PagedIterable<ProjectFileInner> inner = this.serviceClient().list(groupName, serviceName, projectName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectFileImpl((ProjectFileInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProjectFile> getWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        Response<ProjectFileInner> inner = this.serviceClient().getWithResponse(groupName, serviceName, projectName, fileName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectFileImpl((ProjectFileInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectFile get(String groupName, String serviceName, String projectName, String fileName) {
        ProjectFileInner inner = this.serviceClient().get(groupName, serviceName, projectName, fileName);
        if (inner != null) {
            return new ProjectFileImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        return this.serviceClient().deleteWithResponse(groupName, serviceName, projectName, fileName, context);
    }

    @Override
    public void delete(String groupName, String serviceName, String projectName, String fileName) {
        this.serviceClient().delete(groupName, serviceName, projectName, fileName);
    }

    @Override
    public Response<FileStorageInfo> readWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        Response<FileStorageInfoInner> inner = this.serviceClient().readWithResponse(groupName, serviceName, projectName, fileName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FileStorageInfoImpl((FileStorageInfoInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public FileStorageInfo read(String groupName, String serviceName, String projectName, String fileName) {
        FileStorageInfoInner inner = this.serviceClient().read(groupName, serviceName, projectName, fileName);
        if (inner != null) {
            return new FileStorageInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<FileStorageInfo> readWriteWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        Response<FileStorageInfoInner> inner = this.serviceClient().readWriteWithResponse(groupName, serviceName, projectName, fileName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FileStorageInfoImpl((FileStorageInfoInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public FileStorageInfo readWrite(String groupName, String serviceName, String projectName, String fileName) {
        FileStorageInfoInner inner = this.serviceClient().readWrite(groupName, serviceName, projectName, fileName);
        if (inner != null) {
            return new FileStorageInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ProjectFile getById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String fileName = ResourceManagerUtils.getValueFromIdByName(id, "files");
        if (fileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'files'.", id)));
        }
        return (ProjectFile)this.getWithResponse(groupName, serviceName, projectName, fileName, Context.NONE).getValue();
    }

    @Override
    public Response<ProjectFile> getByIdWithResponse(String id, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String fileName = ResourceManagerUtils.getValueFromIdByName(id, "files");
        if (fileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'files'.", id)));
        }
        return this.getWithResponse(groupName, serviceName, projectName, fileName, context);
    }

    @Override
    public void deleteById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String fileName = ResourceManagerUtils.getValueFromIdByName(id, "files");
        if (fileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'files'.", id)));
        }
        this.deleteWithResponse(groupName, serviceName, projectName, fileName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String fileName = ResourceManagerUtils.getValueFromIdByName(id, "files");
        if (fileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'files'.", id)));
        }
        return this.deleteWithResponse(groupName, serviceName, projectName, fileName, context);
    }

    private FilesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectFileImpl define(String name) {
        return new ProjectFileImpl(name, this.manager());
    }
}

