/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlVmsClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlVmInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationSqlVmImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlVm;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlVms;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.util.UUID;

public final class DatabaseMigrationsSqlVmsImpl
implements DatabaseMigrationsSqlVms {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsSqlVmsImpl.class);
    private final DatabaseMigrationsSqlVmsClient innerClient;
    private final DataMigrationManager serviceManager;

    public DatabaseMigrationsSqlVmsImpl(DatabaseMigrationsSqlVmsClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseMigrationSqlVm> getWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, UUID migrationOperationId, String expand, Context context) {
        Response<DatabaseMigrationSqlVmInner> inner = this.serviceClient().getWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseMigrationSqlVmImpl((DatabaseMigrationSqlVmInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlVm get(String resourceGroupName, String sqlVirtualMachineName, String targetDbName) {
        DatabaseMigrationSqlVmInner inner = this.serviceClient().get(resourceGroupName, sqlVirtualMachineName, targetDbName);
        if (inner != null) {
            return new DatabaseMigrationSqlVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlVm delete(String resourceGroupName, String sqlVirtualMachineName, String targetDbName) {
        DatabaseMigrationSqlVmInner inner = this.serviceClient().delete(resourceGroupName, sqlVirtualMachineName, targetDbName);
        if (inner != null) {
            return new DatabaseMigrationSqlVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlVm delete(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, Boolean force, Context context) {
        DatabaseMigrationSqlVmInner inner = this.serviceClient().delete(resourceGroupName, sqlVirtualMachineName, targetDbName, force, context);
        if (inner != null) {
            return new DatabaseMigrationSqlVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void cancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        this.serviceClient().cancel(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
    }

    @Override
    public void cancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.serviceClient().cancel(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context);
    }

    @Override
    public void cutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        this.serviceClient().cutover(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
    }

    @Override
    public void cutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.serviceClient().cutover(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlVm getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlVirtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "sqlVirtualMachines");
        if (sqlVirtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlVirtualMachines'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        UUID localMigrationOperationId = null;
        String localExpand = null;
        return (DatabaseMigrationSqlVm)this.getWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<DatabaseMigrationSqlVm> getByIdWithResponse(String id, UUID migrationOperationId, String expand, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlVirtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "sqlVirtualMachines");
        if (sqlVirtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlVirtualMachines'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand, context);
    }

    @Override
    public DatabaseMigrationSqlVm deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlVirtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "sqlVirtualMachines");
        if (sqlVirtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlVirtualMachines'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        Boolean localForce = null;
        return this.delete(resourceGroupName, sqlVirtualMachineName, targetDbName, localForce, Context.NONE);
    }

    @Override
    public DatabaseMigrationSqlVm deleteByIdWithResponse(String id, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlVirtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "sqlVirtualMachines");
        if (sqlVirtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlVirtualMachines'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.delete(resourceGroupName, sqlVirtualMachineName, targetDbName, force, context);
    }

    private DatabaseMigrationsSqlVmsClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlVmImpl define(String name) {
        return new DatabaseMigrationSqlVmImpl(name, this.manager());
    }
}

