/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationCosmosDbMongoInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationCosmosDbMongoImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationCosmosDbMongo;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsMongoToCosmosDbvCoreMongoes;

public final class DatabaseMigrationsMongoToCosmosDbvCoreMongoesImpl
implements DatabaseMigrationsMongoToCosmosDbvCoreMongoes {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsMongoToCosmosDbvCoreMongoesImpl.class);
    private final DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient innerClient;
    private final DataMigrationManager serviceManager;

    public DatabaseMigrationsMongoToCosmosDbvCoreMongoesImpl(DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseMigrationCosmosDbMongo> getWithResponse(String resourceGroupName, String targetResourceName, String migrationName, Context context) {
        Response<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetResourceName, migrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseMigrationCosmosDbMongo get(String resourceGroupName, String targetResourceName, String migrationName) {
        DatabaseMigrationCosmosDbMongoInner inner = this.serviceClient().get(resourceGroupName, targetResourceName, migrationName);
        if (inner != null) {
            return new DatabaseMigrationCosmosDbMongoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationCosmosDbMongo create(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        DatabaseMigrationCosmosDbMongoInner inner = this.serviceClient().create(resourceGroupName, targetResourceName, migrationName, parameters);
        if (inner != null) {
            return new DatabaseMigrationCosmosDbMongoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationCosmosDbMongo create(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters, Context context) {
        DatabaseMigrationCosmosDbMongoInner inner = this.serviceClient().create(resourceGroupName, targetResourceName, migrationName, parameters, context);
        if (inner != null) {
            return new DatabaseMigrationCosmosDbMongoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetResourceName, String migrationName) {
        this.serviceClient().delete(resourceGroupName, targetResourceName, migrationName);
    }

    @Override
    public void delete(String resourceGroupName, String targetResourceName, String migrationName, Boolean force, Context context) {
        this.serviceClient().delete(resourceGroupName, targetResourceName, migrationName, force, context);
    }

    @Override
    public PagedIterable<DatabaseMigrationCosmosDbMongo> getForScope(String resourceGroupName, String targetResourceName) {
        PagedIterable<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getForScope(resourceGroupName, targetResourceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatabaseMigrationCosmosDbMongo> getForScope(String resourceGroupName, String targetResourceName, Context context) {
        PagedIterable<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getForScope(resourceGroupName, targetResourceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner1), this.manager()));
    }

    private DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }
}

