/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.QuotaName;
import java.io.IOException;

public final class QuotaInner
implements JsonSerializable<QuotaInner> {
    private Double currentValue;
    private String id;
    private Double limit;
    private QuotaName name;
    private String unit;

    public Double currentValue() {
        return this.currentValue;
    }

    public QuotaInner withCurrentValue(Double currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public String id() {
        return this.id;
    }

    public QuotaInner withId(String id) {
        this.id = id;
        return this;
    }

    public Double limit() {
        return this.limit;
    }

    public QuotaInner withLimit(Double limit) {
        this.limit = limit;
        return this;
    }

    public QuotaName name() {
        return this.name;
    }

    public QuotaInner withName(QuotaName name) {
        this.name = name;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public QuotaInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("currentValue", (Number)this.currentValue);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("unit", this.unit);
        return jsonWriter.writeEndObject();
    }

    public static QuotaInner fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaInner)jsonReader.readObject(reader -> {
            QuotaInner deserializedQuotaInner = new QuotaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentValue".equals(fieldName)) {
                    deserializedQuotaInner.currentValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedQuotaInner.id = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedQuotaInner.limit = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedQuotaInner.name = QuotaName.fromJson(reader);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedQuotaInner.unit = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaInner;
        });
    }
}

