/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import java.io.IOException;

public final class ProjectTaskInner
extends ProxyResource {
    private String etag;
    private ProjectTaskProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    public ProjectTaskInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public ProjectTaskProperties properties() {
        return this.properties;
    }

    public ProjectTaskInner withProperties(ProjectTaskProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ProjectTaskInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectTaskInner)((Object)jsonReader.readObject(reader -> {
            ProjectTaskInner deserializedProjectTaskInner = new ProjectTaskInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProjectTaskInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProjectTaskInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProjectTaskInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedProjectTaskInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProjectTaskInner.properties = ProjectTaskProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProjectTaskInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectTaskInner;
        }));
    }
}

