/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import com.azure.resourcemanager.datafactory.models.XmlReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class XmlSource
extends CopySource {
    private String type = "XmlSource";
    private StoreReadSettings storeSettings;
    private XmlReadSettings formatSettings;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public XmlSource withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public XmlReadSettings formatSettings() {
        return this.formatSettings;
    }

    public XmlSource withFormatSettings(XmlReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public XmlSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public XmlSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public XmlSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public XmlSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public XmlSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static XmlSource fromJson(JsonReader jsonReader) throws IOException {
        return (XmlSource)jsonReader.readObject(reader -> {
            XmlSource deserializedXmlSource = new XmlSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedXmlSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedXmlSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedXmlSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedXmlSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedXmlSource.type = reader.getString();
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedXmlSource.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedXmlSource.formatSettings = XmlReadSettings.fromJson(reader);
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedXmlSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedXmlSource.withAdditionalProperties(additionalProperties);
            return deserializedXmlSource;
        });
    }
}

