/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.WebhookActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.SecureInputOutputPolicy;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebhookActivityMethod;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class WebhookActivity
extends ControlActivity {
    private String type = "WebHook";
    private WebhookActivityTypeProperties innerTypeProperties = new WebhookActivityTypeProperties();
    private SecureInputOutputPolicy policy;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    WebhookActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public SecureInputOutputPolicy policy() {
        return this.policy;
    }

    public WebhookActivity withPolicy(SecureInputOutputPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public WebhookActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public WebhookActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public WebhookActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public WebhookActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public WebhookActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public WebhookActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public WebhookActivityMethod method() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().method();
    }

    public WebhookActivity withMethod(WebhookActivityMethod method) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withMethod(method);
        return this;
    }

    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    public WebhookActivity withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    public String timeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().timeout();
    }

    public WebhookActivity withTimeout(String timeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withTimeout(timeout);
        return this;
    }

    public Map<String, Object> headers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().headers();
    }

    public WebhookActivity withHeaders(Map<String, Object> headers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withHeaders(headers);
        return this;
    }

    public Object body() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().body();
    }

    public WebhookActivity withBody(Object body) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withBody(body);
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public WebhookActivity withAuthentication(WebActivityAuthentication authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    public Object reportStatusOnCallBack() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().reportStatusOnCallBack();
    }

    public WebhookActivity withReportStatusOnCallBack(Object reportStatusOnCallBack) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebhookActivityTypeProperties();
        }
        this.innerTypeProperties().withReportStatusOnCallBack(reportStatusOnCallBack);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model WebhookActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WebhookActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WebhookActivity fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookActivity)jsonReader.readObject(reader -> {
            WebhookActivity deserializedWebhookActivity = new WebhookActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebhookActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWebhookActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWebhookActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedWebhookActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedWebhookActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedWebhookActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedWebhookActivity.innerTypeProperties = WebhookActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebhookActivity.type = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedWebhookActivity.policy = SecureInputOutputPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWebhookActivity.withAdditionalProperties(additionalProperties);
            return deserializedWebhookActivity;
        });
    }
}

