/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.NotebookReferenceType;
import java.io.IOException;

public final class SynapseNotebookReference
implements JsonSerializable<SynapseNotebookReference> {
    private NotebookReferenceType type;
    private Object referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookReference.class);

    public NotebookReferenceType type() {
        return this.type;
    }

    public SynapseNotebookReference withType(NotebookReferenceType type) {
        this.type = type;
        return this;
    }

    public Object referenceName() {
        return this.referenceName;
    }

    public SynapseNotebookReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SynapseNotebookReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model SynapseNotebookReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static SynapseNotebookReference fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseNotebookReference)jsonReader.readObject(reader -> {
            SynapseNotebookReference deserializedSynapseNotebookReference = new SynapseNotebookReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSynapseNotebookReference.type = NotebookReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedSynapseNotebookReference.referenceName = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSynapseNotebookReference;
        });
    }
}

