/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SqlServerLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import com.azure.resourcemanager.datafactory.models.SqlServerAuthenticationType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SqlServerLinkedService
extends LinkedService {
    private String type = "SqlServer";
    private SqlServerLinkedServiceTypeProperties innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SqlServerLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SqlServerLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SqlServerLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SqlServerLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SqlServerLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SqlServerLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SqlServerLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public SqlServerLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public SqlServerAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public SqlServerLinkedService withAuthenticationType(SqlServerAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SqlServerLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SqlServerLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SqlServerLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().alwaysEncryptedSettings();
    }

    public SqlServerLinkedService withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAlwaysEncryptedSettings(alwaysEncryptedSettings);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public SqlServerLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public SqlServerLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public SqlServerLinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object encrypt() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encrypt();
    }

    public SqlServerLinkedService withEncrypt(Object encrypt) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncrypt(encrypt);
        return this;
    }

    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    public SqlServerLinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    public Object hostnameInCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hostnameInCertificate();
    }

    public SqlServerLinkedService withHostnameInCertificate(Object hostnameInCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    public Object applicationIntent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().applicationIntent();
    }

    public SqlServerLinkedService withApplicationIntent(Object applicationIntent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApplicationIntent(applicationIntent);
        return this;
    }

    public Object connectTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectTimeout();
    }

    public SqlServerLinkedService withConnectTimeout(Object connectTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectTimeout(connectTimeout);
        return this;
    }

    public Object connectRetryCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryCount();
    }

    public SqlServerLinkedService withConnectRetryCount(Object connectRetryCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryCount(connectRetryCount);
        return this;
    }

    public Object connectRetryInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryInterval();
    }

    public SqlServerLinkedService withConnectRetryInterval(Object connectRetryInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    public Object loadBalanceTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loadBalanceTimeout();
    }

    public SqlServerLinkedService withLoadBalanceTimeout(Object loadBalanceTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public SqlServerLinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    public Object integratedSecurity() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integratedSecurity();
    }

    public SqlServerLinkedService withIntegratedSecurity(Object integratedSecurity) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIntegratedSecurity(integratedSecurity);
        return this;
    }

    public Object failoverPartner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().failoverPartner();
    }

    public SqlServerLinkedService withFailoverPartner(Object failoverPartner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFailoverPartner(failoverPartner);
        return this;
    }

    public Object maxPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxPoolSize();
    }

    public SqlServerLinkedService withMaxPoolSize(Object maxPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMaxPoolSize(maxPoolSize);
        return this;
    }

    public Object minPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minPoolSize();
    }

    public SqlServerLinkedService withMinPoolSize(Object minPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMinPoolSize(minPoolSize);
        return this;
    }

    public Object multipleActiveResultSets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multipleActiveResultSets();
    }

    public SqlServerLinkedService withMultipleActiveResultSets(Object multipleActiveResultSets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    public Object multiSubnetFailover() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multiSubnetFailover();
    }

    public SqlServerLinkedService withMultiSubnetFailover(Object multiSubnetFailover) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    public Object packetSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packetSize();
    }

    public SqlServerLinkedService withPacketSize(Object packetSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPacketSize(packetSize);
        return this;
    }

    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    public SqlServerLinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SqlServerLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlServerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerLinkedService)jsonReader.readObject(reader -> {
            SqlServerLinkedService deserializedSqlServerLinkedService = new SqlServerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSqlServerLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSqlServerLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSqlServerLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSqlServerLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSqlServerLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSqlServerLinkedService.innerTypeProperties = SqlServerLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlServerLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlServerLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSqlServerLinkedService;
        });
    }
}

