/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapOdpSource
extends TabularSource {
    private String type = "SapOdpSource";
    private Object extractionMode;
    private Object subscriberProcess;
    private Object selection;
    private Object projection;

    @Override
    public String type() {
        return this.type;
    }

    public Object extractionMode() {
        return this.extractionMode;
    }

    public SapOdpSource withExtractionMode(Object extractionMode) {
        this.extractionMode = extractionMode;
        return this;
    }

    public Object subscriberProcess() {
        return this.subscriberProcess;
    }

    public SapOdpSource withSubscriberProcess(Object subscriberProcess) {
        this.subscriberProcess = subscriberProcess;
        return this;
    }

    public Object selection() {
        return this.selection;
    }

    public SapOdpSource withSelection(Object selection) {
        this.selection = selection;
        return this;
    }

    public Object projection() {
        return this.projection;
    }

    public SapOdpSource withProjection(Object projection) {
        this.projection = projection;
        return this;
    }

    @Override
    public SapOdpSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SapOdpSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SapOdpSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SapOdpSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SapOdpSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SapOdpSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.queryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        }
        if (this.additionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.extractionMode != null) {
            jsonWriter.writeUntypedField("extractionMode", this.extractionMode);
        }
        if (this.subscriberProcess != null) {
            jsonWriter.writeUntypedField("subscriberProcess", this.subscriberProcess);
        }
        if (this.selection != null) {
            jsonWriter.writeUntypedField("selection", this.selection);
        }
        if (this.projection != null) {
            jsonWriter.writeUntypedField("projection", this.projection);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOdpSource fromJson(JsonReader jsonReader) throws IOException {
        return (SapOdpSource)jsonReader.readObject(reader -> {
            SapOdpSource deserializedSapOdpSource = new SapOdpSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSapOdpSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSapOdpSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapOdpSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSapOdpSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSapOdpSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSapOdpSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOdpSource.type = reader.getString();
                    continue;
                }
                if ("extractionMode".equals(fieldName)) {
                    deserializedSapOdpSource.extractionMode = reader.readUntyped();
                    continue;
                }
                if ("subscriberProcess".equals(fieldName)) {
                    deserializedSapOdpSource.subscriberProcess = reader.readUntyped();
                    continue;
                }
                if ("selection".equals(fieldName)) {
                    deserializedSapOdpSource.selection = reader.readUntyped();
                    continue;
                }
                if ("projection".equals(fieldName)) {
                    deserializedSapOdpSource.projection = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOdpSource.withAdditionalProperties(additionalProperties);
            return deserializedSapOdpSource;
        });
    }
}

