/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.RerunTumblingWindowTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RerunTumblingWindowTrigger
extends Trigger {
    private String type = "RerunTumblingWindowTrigger";
    private RerunTumblingWindowTriggerTypeProperties innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(RerunTumblingWindowTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    RerunTumblingWindowTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public RerunTumblingWindowTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public RerunTumblingWindowTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object parentTrigger() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parentTrigger();
    }

    public RerunTumblingWindowTrigger withParentTrigger(Object parentTrigger) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withParentTrigger(parentTrigger);
        return this;
    }

    public OffsetDateTime requestedStartTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestedStartTime();
    }

    public RerunTumblingWindowTrigger withRequestedStartTime(OffsetDateTime requestedStartTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRequestedStartTime(requestedStartTime);
        return this;
    }

    public OffsetDateTime requestedEndTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestedEndTime();
    }

    public RerunTumblingWindowTrigger withRequestedEndTime(OffsetDateTime requestedEndTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRequestedEndTime(requestedEndTime);
        return this;
    }

    public int rerunConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().rerunConcurrency();
    }

    public RerunTumblingWindowTrigger withRerunConcurrency(int rerunConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRerunConcurrency(rerunConcurrency);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model RerunTumblingWindowTrigger"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RerunTumblingWindowTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (RerunTumblingWindowTrigger)jsonReader.readObject(reader -> {
            RerunTumblingWindowTrigger deserializedRerunTumblingWindowTrigger = new RerunTumblingWindowTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRerunTumblingWindowTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.innerTypeProperties = RerunTumblingWindowTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRerunTumblingWindowTrigger.withAdditionalProperties(additionalProperties);
            return deserializedRerunTumblingWindowTrigger;
        });
    }
}

