/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.ParquetWriteSettings;
import com.azure.resourcemanager.datafactory.models.StoreWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ParquetSink
extends CopySink {
    private String type = "ParquetSink";
    private StoreWriteSettings storeSettings;
    private ParquetWriteSettings formatSettings;

    @Override
    public String type() {
        return this.type;
    }

    public StoreWriteSettings storeSettings() {
        return this.storeSettings;
    }

    public ParquetSink withStoreSettings(StoreWriteSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public ParquetWriteSettings formatSettings() {
        return this.formatSettings;
    }

    public ParquetSink withFormatSettings(ParquetWriteSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    @Override
    public ParquetSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public ParquetSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public ParquetSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public ParquetSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public ParquetSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public ParquetSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ParquetSink fromJson(JsonReader jsonReader) throws IOException {
        return (ParquetSink)jsonReader.readObject(reader -> {
            ParquetSink deserializedParquetSink = new ParquetSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedParquetSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedParquetSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedParquetSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedParquetSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedParquetSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedParquetSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedParquetSink.type = reader.getString();
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedParquetSink.storeSettings = StoreWriteSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedParquetSink.formatSettings = ParquetWriteSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedParquetSink.withAdditionalProperties(additionalProperties);
            return deserializedParquetSink;
        });
    }
}

