/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.OperationLogSpecification;
import com.azure.resourcemanager.datafactory.models.OperationMetricSpecification;
import java.io.IOException;
import java.util.List;

public final class OperationServiceSpecification
implements JsonSerializable<OperationServiceSpecification> {
    private List<OperationLogSpecification> logSpecifications;
    private List<OperationMetricSpecification> metricSpecifications;

    public List<OperationLogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public OperationServiceSpecification withLogSpecifications(List<OperationLogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public List<OperationMetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public OperationServiceSpecification withMetricSpecifications(List<OperationMetricSpecification> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    public void validate() {
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
        if (this.metricSpecifications() != null) {
            this.metricSpecifications().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metricSpecifications", this.metricSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationServiceSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (OperationServiceSpecification)jsonReader.readObject(reader -> {
            OperationServiceSpecification deserializedOperationServiceSpecification = new OperationServiceSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logSpecifications".equals(fieldName)) {
                    List logSpecifications;
                    deserializedOperationServiceSpecification.logSpecifications = logSpecifications = reader.readArray(reader1 -> OperationLogSpecification.fromJson(reader1));
                    continue;
                }
                if ("metricSpecifications".equals(fieldName)) {
                    List metricSpecifications;
                    deserializedOperationServiceSpecification.metricSpecifications = metricSpecifications = reader.readArray(reader1 -> OperationMetricSpecification.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationServiceSpecification;
        });
    }
}

