/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ConnectionType;
import java.io.IOException;

public final class MapperConnectionReference
implements JsonSerializable<MapperConnectionReference> {
    private String connectionName;
    private ConnectionType type;

    public String connectionName() {
        return this.connectionName;
    }

    public MapperConnectionReference withConnectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public ConnectionType type() {
        return this.type;
    }

    public MapperConnectionReference withType(ConnectionType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionName", this.connectionName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MapperConnectionReference fromJson(JsonReader jsonReader) throws IOException {
        return (MapperConnectionReference)jsonReader.readObject(reader -> {
            MapperConnectionReference deserializedMapperConnectionReference = new MapperConnectionReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionName".equals(fieldName)) {
                    deserializedMapperConnectionReference.connectionName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMapperConnectionReference.type = ConnectionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperConnectionReference;
        });
    }
}

