/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ConnectionType;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.MapperDslConnectorProperties;
import java.io.IOException;
import java.util.List;

public final class MapperConnection
implements JsonSerializable<MapperConnection> {
    private LinkedServiceReference linkedService;
    private String linkedServiceType;
    private ConnectionType type;
    private Boolean isInlineDataset;
    private List<MapperDslConnectorProperties> commonDslConnectorProperties;
    private static final ClientLogger LOGGER = new ClientLogger(MapperConnection.class);

    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    public MapperConnection withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public String linkedServiceType() {
        return this.linkedServiceType;
    }

    public MapperConnection withLinkedServiceType(String linkedServiceType) {
        this.linkedServiceType = linkedServiceType;
        return this;
    }

    public ConnectionType type() {
        return this.type;
    }

    public MapperConnection withType(ConnectionType type) {
        this.type = type;
        return this;
    }

    public Boolean isInlineDataset() {
        return this.isInlineDataset;
    }

    public MapperConnection withIsInlineDataset(Boolean isInlineDataset) {
        this.isInlineDataset = isInlineDataset;
        return this;
    }

    public List<MapperDslConnectorProperties> commonDslConnectorProperties() {
        return this.commonDslConnectorProperties;
    }

    public MapperConnection withCommonDslConnectorProperties(List<MapperDslConnectorProperties> commonDslConnectorProperties) {
        this.commonDslConnectorProperties = commonDslConnectorProperties;
        return this;
    }

    public void validate() {
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model MapperConnection"));
        }
        if (this.commonDslConnectorProperties() != null) {
            this.commonDslConnectorProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        jsonWriter.writeStringField("linkedServiceType", this.linkedServiceType);
        jsonWriter.writeBooleanField("isInlineDataset", this.isInlineDataset);
        jsonWriter.writeArrayField("commonDslConnectorProperties", this.commonDslConnectorProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MapperConnection fromJson(JsonReader jsonReader) throws IOException {
        return (MapperConnection)jsonReader.readObject(reader -> {
            MapperConnection deserializedMapperConnection = new MapperConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedMapperConnection.type = ConnectionType.fromString(reader.getString());
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedMapperConnection.linkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("linkedServiceType".equals(fieldName)) {
                    deserializedMapperConnection.linkedServiceType = reader.getString();
                    continue;
                }
                if ("isInlineDataset".equals(fieldName)) {
                    deserializedMapperConnection.isInlineDataset = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("commonDslConnectorProperties".equals(fieldName)) {
                    List commonDslConnectorProperties;
                    deserializedMapperConnection.commonDslConnectorProperties = commonDslConnectorProperties = reader.readArray(reader1 -> MapperDslConnectorProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperConnection;
        });
    }
}

