/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIntegrationRuntimeStatusTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeState;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatus;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeError;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeNode;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeOperationResult;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedIntegrationRuntimeStatus
extends IntegrationRuntimeStatus {
    private IntegrationRuntimeType type = IntegrationRuntimeType.MANAGED;
    private ManagedIntegrationRuntimeStatusTypeProperties innerTypeProperties = new ManagedIntegrationRuntimeStatusTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIntegrationRuntimeStatus.class);

    @Override
    public IntegrationRuntimeType type() {
        return this.type;
    }

    ManagedIntegrationRuntimeStatusTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public OffsetDateTime createTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().createTime();
    }

    public List<ManagedIntegrationRuntimeNode> nodes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nodes();
    }

    public List<ManagedIntegrationRuntimeError> otherErrors() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().otherErrors();
    }

    public ManagedIntegrationRuntimeOperationResult lastOperation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().lastOperation();
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ManagedIntegrationRuntimeStatus"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntimeStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntimeStatus)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntimeStatus deserializedManagedIntegrationRuntimeStatus = new ManagedIntegrationRuntimeStatus();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataFactoryName".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatus.withDataFactoryName(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatus.withState(IntegrationRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatus.innerTypeProperties = ManagedIntegrationRuntimeStatusTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeStatus.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIntegrationRuntimeStatus.withAdditionalProperties(additionalProperties);
            return deserializedManagedIntegrationRuntimeStatus;
        });
    }
}

