/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HttpReadSettings
extends StoreReadSettings {
    private String type = "HttpReadSettings";
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private Object requestTimeout;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object requestMethod() {
        return this.requestMethod;
    }

    public HttpReadSettings withRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object requestBody() {
        return this.requestBody;
    }

    public HttpReadSettings withRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object additionalHeaders() {
        return this.additionalHeaders;
    }

    public HttpReadSettings withAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object requestTimeout() {
        return this.requestTimeout;
    }

    public HttpReadSettings withRequestTimeout(Object requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public HttpReadSettings withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public HttpReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public HttpReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.requestMethod != null) {
            jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        }
        if (this.requestBody != null) {
            jsonWriter.writeUntypedField("requestBody", this.requestBody);
        }
        if (this.additionalHeaders != null) {
            jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        }
        if (this.requestTimeout != null) {
            jsonWriter.writeUntypedField("requestTimeout", this.requestTimeout);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (HttpReadSettings)jsonReader.readObject(reader -> {
            HttpReadSettings deserializedHttpReadSettings = new HttpReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedHttpReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedHttpReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpReadSettings.type = reader.getString();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedHttpReadSettings.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedHttpReadSettings.requestBody = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedHttpReadSettings.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("requestTimeout".equals(fieldName)) {
                    deserializedHttpReadSettings.requestTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedHttpReadSettings.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedHttpReadSettings;
        });
    }
}

