/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.GoogleBigQueryV2DatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GoogleBigQueryV2ObjectDataset
extends Dataset {
    private String type = "GoogleBigQueryV2Object";
    private GoogleBigQueryV2DatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(GoogleBigQueryV2ObjectDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    GoogleBigQueryV2DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public GoogleBigQueryV2ObjectDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object table() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().table();
    }

    public GoogleBigQueryV2ObjectDataset withTable(Object table) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2DatasetTypeProperties();
        }
        this.innerTypeProperties().withTable(table);
        return this;
    }

    public Object dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    public GoogleBigQueryV2ObjectDataset withDataset(Object dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2DatasetTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model GoogleBigQueryV2ObjectDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        if (this.structure() != null) {
            jsonWriter.writeUntypedField("structure", this.structure());
        }
        if (this.schema() != null) {
            jsonWriter.writeUntypedField("schema", this.schema());
        }
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryV2ObjectDataset fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryV2ObjectDataset)jsonReader.readObject(reader -> {
            GoogleBigQueryV2ObjectDataset deserializedGoogleBigQueryV2ObjectDataset = new GoogleBigQueryV2ObjectDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleBigQueryV2ObjectDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleBigQueryV2ObjectDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedGoogleBigQueryV2ObjectDataset.innerTypeProperties = GoogleBigQueryV2DatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleBigQueryV2ObjectDataset.withAdditionalProperties(additionalProperties);
            return deserializedGoogleBigQueryV2ObjectDataset;
        });
    }
}

