/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DatasetResourceInner;
import java.io.IOException;
import java.util.List;

public final class DatasetListResponse
implements JsonSerializable<DatasetListResponse> {
    private List<DatasetResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DatasetListResponse.class);

    public List<DatasetResourceInner> value() {
        return this.value;
    }

    public DatasetListResponse withValue(List<DatasetResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DatasetListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DatasetListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DatasetListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetListResponse)jsonReader.readObject(reader -> {
            DatasetListResponse deserializedDatasetListResponse = new DatasetListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDatasetListResponse.value = value = reader.readArray(reader1 -> DatasetResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDatasetListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasetListResponse;
        });
    }
}

