/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperAttributeMappings;
import com.azure.resourcemanager.datafactory.models.MapperConnectionReference;
import java.io.IOException;

public final class DataMapperMapping
implements JsonSerializable<DataMapperMapping> {
    private String targetEntityName;
    private String sourceEntityName;
    private MapperConnectionReference sourceConnectionReference;
    private MapperAttributeMappings attributeMappingInfo;
    private Object sourceDenormalizeInfo;

    public String targetEntityName() {
        return this.targetEntityName;
    }

    public DataMapperMapping withTargetEntityName(String targetEntityName) {
        this.targetEntityName = targetEntityName;
        return this;
    }

    public String sourceEntityName() {
        return this.sourceEntityName;
    }

    public DataMapperMapping withSourceEntityName(String sourceEntityName) {
        this.sourceEntityName = sourceEntityName;
        return this;
    }

    public MapperConnectionReference sourceConnectionReference() {
        return this.sourceConnectionReference;
    }

    public DataMapperMapping withSourceConnectionReference(MapperConnectionReference sourceConnectionReference) {
        this.sourceConnectionReference = sourceConnectionReference;
        return this;
    }

    public MapperAttributeMappings attributeMappingInfo() {
        return this.attributeMappingInfo;
    }

    public DataMapperMapping withAttributeMappingInfo(MapperAttributeMappings attributeMappingInfo) {
        this.attributeMappingInfo = attributeMappingInfo;
        return this;
    }

    public Object sourceDenormalizeInfo() {
        return this.sourceDenormalizeInfo;
    }

    public DataMapperMapping withSourceDenormalizeInfo(Object sourceDenormalizeInfo) {
        this.sourceDenormalizeInfo = sourceDenormalizeInfo;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionReference() != null) {
            this.sourceConnectionReference().validate();
        }
        if (this.attributeMappingInfo() != null) {
            this.attributeMappingInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetEntityName", this.targetEntityName);
        jsonWriter.writeStringField("sourceEntityName", this.sourceEntityName);
        jsonWriter.writeJsonField("sourceConnectionReference", (JsonSerializable)this.sourceConnectionReference);
        jsonWriter.writeJsonField("attributeMappingInfo", (JsonSerializable)this.attributeMappingInfo);
        if (this.sourceDenormalizeInfo != null) {
            jsonWriter.writeUntypedField("sourceDenormalizeInfo", this.sourceDenormalizeInfo);
        }
        return jsonWriter.writeEndObject();
    }

    public static DataMapperMapping fromJson(JsonReader jsonReader) throws IOException {
        return (DataMapperMapping)jsonReader.readObject(reader -> {
            DataMapperMapping deserializedDataMapperMapping = new DataMapperMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetEntityName".equals(fieldName)) {
                    deserializedDataMapperMapping.targetEntityName = reader.getString();
                    continue;
                }
                if ("sourceEntityName".equals(fieldName)) {
                    deserializedDataMapperMapping.sourceEntityName = reader.getString();
                    continue;
                }
                if ("sourceConnectionReference".equals(fieldName)) {
                    deserializedDataMapperMapping.sourceConnectionReference = MapperConnectionReference.fromJson(reader);
                    continue;
                }
                if ("attributeMappingInfo".equals(fieldName)) {
                    deserializedDataMapperMapping.attributeMappingInfo = MapperAttributeMappings.fromJson(reader);
                    continue;
                }
                if ("sourceDenormalizeInfo".equals(fieldName)) {
                    deserializedDataMapperMapping.sourceDenormalizeInfo = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMapperMapping;
        });
    }
}

