/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.Transformation;
import java.io.IOException;

public class DataFlowSink
extends Transformation {
    private LinkedServiceReference schemaLinkedService;
    private LinkedServiceReference rejectedDataLinkedService;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowSink.class);

    public LinkedServiceReference schemaLinkedService() {
        return this.schemaLinkedService;
    }

    public DataFlowSink withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        this.schemaLinkedService = schemaLinkedService;
        return this;
    }

    public LinkedServiceReference rejectedDataLinkedService() {
        return this.rejectedDataLinkedService;
    }

    public DataFlowSink withRejectedDataLinkedService(LinkedServiceReference rejectedDataLinkedService) {
        this.rejectedDataLinkedService = rejectedDataLinkedService;
        return this;
    }

    @Override
    public DataFlowSink withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DataFlowSink withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DataFlowSink withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    @Override
    public DataFlowSink withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    @Override
    public DataFlowSink withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    @Override
    public void validate() {
        if (this.schemaLinkedService() != null) {
            this.schemaLinkedService().validate();
        }
        if (this.rejectedDataLinkedService() != null) {
            this.rejectedDataLinkedService().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DataFlowSink"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService);
        jsonWriter.writeJsonField("rejectedDataLinkedService", (JsonSerializable)this.rejectedDataLinkedService);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowSink fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowSink)jsonReader.readObject(reader -> {
            DataFlowSink deserializedDataFlowSink = new DataFlowSink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataFlowSink.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlowSink.withDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedDataFlowSink.withDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedDataFlowSink.withLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedDataFlowSink.withFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedDataFlowSink.schemaLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("rejectedDataLinkedService".equals(fieldName)) {
                    deserializedDataFlowSink.rejectedDataLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowSink;
        });
    }
}

