/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowResourceInner;
import java.io.IOException;
import java.util.List;

public final class DataFlowListResponse
implements JsonSerializable<DataFlowListResponse> {
    private List<DataFlowResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowListResponse.class);

    public List<DataFlowResourceInner> value() {
        return this.value;
    }

    public DataFlowListResponse withValue(List<DataFlowResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DataFlowListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DataFlowListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowListResponse)jsonReader.readObject(reader -> {
            DataFlowListResponse deserializedDataFlowListResponse = new DataFlowListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDataFlowListResponse.value = value = reader.readArray(reader1 -> DataFlowResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDataFlowListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowListResponse;
        });
    }
}

