/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DataFlowDebugCommandPayload
implements JsonSerializable<DataFlowDebugCommandPayload> {
    private String streamName;
    private Integer rowLimits;
    private List<String> columns;
    private String expression;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowDebugCommandPayload.class);

    public String streamName() {
        return this.streamName;
    }

    public DataFlowDebugCommandPayload withStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public Integer rowLimits() {
        return this.rowLimits;
    }

    public DataFlowDebugCommandPayload withRowLimits(Integer rowLimits) {
        this.rowLimits = rowLimits;
        return this;
    }

    public List<String> columns() {
        return this.columns;
    }

    public DataFlowDebugCommandPayload withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public String expression() {
        return this.expression;
    }

    public DataFlowDebugCommandPayload withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public void validate() {
        if (this.streamName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property streamName in model DataFlowDebugCommandPayload"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("streamName", this.streamName);
        jsonWriter.writeNumberField("rowLimits", (Number)this.rowLimits);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expression", this.expression);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowDebugCommandPayload fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowDebugCommandPayload)jsonReader.readObject(reader -> {
            DataFlowDebugCommandPayload deserializedDataFlowDebugCommandPayload = new DataFlowDebugCommandPayload();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streamName".equals(fieldName)) {
                    deserializedDataFlowDebugCommandPayload.streamName = reader.getString();
                    continue;
                }
                if ("rowLimits".equals(fieldName)) {
                    deserializedDataFlowDebugCommandPayload.rowLimits = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List columns;
                    deserializedDataFlowDebugCommandPayload.columns = columns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("expression".equals(fieldName)) {
                    deserializedDataFlowDebugCommandPayload.expression = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowDebugCommandPayload;
        });
    }
}

