/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;

public final class CustomActivityReferenceObject
implements JsonSerializable<CustomActivityReferenceObject> {
    private List<LinkedServiceReference> linkedServices;
    private List<DatasetReference> datasets;

    public List<LinkedServiceReference> linkedServices() {
        return this.linkedServices;
    }

    public CustomActivityReferenceObject withLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public List<DatasetReference> datasets() {
        return this.datasets;
    }

    public CustomActivityReferenceObject withDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    public void validate() {
        if (this.linkedServices() != null) {
            this.linkedServices().forEach(e -> e.validate());
        }
        if (this.datasets() != null) {
            this.datasets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("linkedServices", this.linkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("datasets", this.datasets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomActivityReferenceObject fromJson(JsonReader jsonReader) throws IOException {
        return (CustomActivityReferenceObject)jsonReader.readObject(reader -> {
            CustomActivityReferenceObject deserializedCustomActivityReferenceObject = new CustomActivityReferenceObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServices".equals(fieldName)) {
                    List linkedServices;
                    deserializedCustomActivityReferenceObject.linkedServices = linkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("datasets".equals(fieldName)) {
                    List datasets;
                    deserializedCustomActivityReferenceObject.datasets = datasets = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomActivityReferenceObject;
        });
    }
}

