/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureMLExecutePipelineActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureMLExecutePipelineActivity
extends ExecutionActivity {
    private String type = "AzureMLExecutePipeline";
    private AzureMLExecutePipelineActivityTypeProperties innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLExecutePipelineActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureMLExecutePipelineActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureMLExecutePipelineActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object mlPipelineId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineId();
    }

    public AzureMLExecutePipelineActivity withMlPipelineId(Object mlPipelineId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineId(mlPipelineId);
        return this;
    }

    public Object mlPipelineEndpointId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineEndpointId();
    }

    public AzureMLExecutePipelineActivity withMlPipelineEndpointId(Object mlPipelineEndpointId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineEndpointId(mlPipelineEndpointId);
        return this;
    }

    public Object version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    public AzureMLExecutePipelineActivity withVersion(Object version) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withVersion(version);
        return this;
    }

    public Object experimentName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().experimentName();
    }

    public AzureMLExecutePipelineActivity withExperimentName(Object experimentName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withExperimentName(experimentName);
        return this;
    }

    public Object mlPipelineParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineParameters();
    }

    public AzureMLExecutePipelineActivity withMlPipelineParameters(Object mlPipelineParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineParameters(mlPipelineParameters);
        return this;
    }

    public Object dataPathAssignments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataPathAssignments();
    }

    public AzureMLExecutePipelineActivity withDataPathAssignments(Object dataPathAssignments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withDataPathAssignments(dataPathAssignments);
        return this;
    }

    public Object mlParentRunId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlParentRunId();
    }

    public AzureMLExecutePipelineActivity withMlParentRunId(Object mlParentRunId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlParentRunId(mlParentRunId);
        return this;
    }

    public Object continueOnStepFailure() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continueOnStepFailure();
    }

    public AzureMLExecutePipelineActivity withContinueOnStepFailure(Object continueOnStepFailure) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withContinueOnStepFailure(continueOnStepFailure);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureMLExecutePipelineActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureMLExecutePipelineActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLExecutePipelineActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLExecutePipelineActivity)jsonReader.readObject(reader -> {
            AzureMLExecutePipelineActivity deserializedAzureMLExecutePipelineActivity = new AzureMLExecutePipelineActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureMLExecutePipelineActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureMLExecutePipelineActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.innerTypeProperties = AzureMLExecutePipelineActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLExecutePipelineActivity.withAdditionalProperties(additionalProperties);
            return deserializedAzureMLExecutePipelineActivity;
        });
    }
}

