/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonRdsForSqlServerLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AmazonRdsForSqlAuthenticationType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AmazonRdsForSqlServerLinkedService
extends LinkedService {
    private String type = "AmazonRdsForSqlServer";
    private AmazonRdsForSqlServerLinkedServiceTypeProperties innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForSqlServerLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AmazonRdsForSqlServerLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AmazonRdsForSqlServerLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AmazonRdsForSqlServerLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AmazonRdsForSqlAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public AmazonRdsForSqlServerLinkedService withAuthenticationType(AmazonRdsForSqlAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public AmazonRdsForSqlServerLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public AmazonRdsForSqlServerLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AmazonRdsForSqlServerLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().alwaysEncryptedSettings();
    }

    public AmazonRdsForSqlServerLinkedService withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAlwaysEncryptedSettings(alwaysEncryptedSettings);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public AmazonRdsForSqlServerLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public AmazonRdsForSqlServerLinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object encrypt() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encrypt();
    }

    public AmazonRdsForSqlServerLinkedService withEncrypt(Object encrypt) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncrypt(encrypt);
        return this;
    }

    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    public AmazonRdsForSqlServerLinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    public Object hostnameInCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hostnameInCertificate();
    }

    public AmazonRdsForSqlServerLinkedService withHostnameInCertificate(Object hostnameInCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    public Object applicationIntent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().applicationIntent();
    }

    public AmazonRdsForSqlServerLinkedService withApplicationIntent(Object applicationIntent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApplicationIntent(applicationIntent);
        return this;
    }

    public Object connectTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectTimeout();
    }

    public AmazonRdsForSqlServerLinkedService withConnectTimeout(Object connectTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectTimeout(connectTimeout);
        return this;
    }

    public Object connectRetryCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryCount();
    }

    public AmazonRdsForSqlServerLinkedService withConnectRetryCount(Object connectRetryCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryCount(connectRetryCount);
        return this;
    }

    public Object connectRetryInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryInterval();
    }

    public AmazonRdsForSqlServerLinkedService withConnectRetryInterval(Object connectRetryInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    public Object loadBalanceTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loadBalanceTimeout();
    }

    public AmazonRdsForSqlServerLinkedService withLoadBalanceTimeout(Object loadBalanceTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public AmazonRdsForSqlServerLinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    public Object integratedSecurity() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integratedSecurity();
    }

    public AmazonRdsForSqlServerLinkedService withIntegratedSecurity(Object integratedSecurity) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIntegratedSecurity(integratedSecurity);
        return this;
    }

    public Object failoverPartner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().failoverPartner();
    }

    public AmazonRdsForSqlServerLinkedService withFailoverPartner(Object failoverPartner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFailoverPartner(failoverPartner);
        return this;
    }

    public Object maxPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxPoolSize();
    }

    public AmazonRdsForSqlServerLinkedService withMaxPoolSize(Object maxPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMaxPoolSize(maxPoolSize);
        return this;
    }

    public Object minPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minPoolSize();
    }

    public AmazonRdsForSqlServerLinkedService withMinPoolSize(Object minPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMinPoolSize(minPoolSize);
        return this;
    }

    public Object multipleActiveResultSets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multipleActiveResultSets();
    }

    public AmazonRdsForSqlServerLinkedService withMultipleActiveResultSets(Object multipleActiveResultSets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    public Object multiSubnetFailover() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multiSubnetFailover();
    }

    public AmazonRdsForSqlServerLinkedService withMultiSubnetFailover(Object multiSubnetFailover) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    public Object packetSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packetSize();
    }

    public AmazonRdsForSqlServerLinkedService withPacketSize(Object packetSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPacketSize(packetSize);
        return this;
    }

    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    public AmazonRdsForSqlServerLinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AmazonRdsForSqlServerLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForSqlServerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForSqlServerLinkedService)jsonReader.readObject(reader -> {
            AmazonRdsForSqlServerLinkedService deserializedAmazonRdsForSqlServerLinkedService = new AmazonRdsForSqlServerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonRdsForSqlServerLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonRdsForSqlServerLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedService.innerTypeProperties = AmazonRdsForSqlServerLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForSqlServerLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForSqlServerLinkedService;
        });
    }
}

