/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DependencyCondition;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ActivityDependency
implements JsonSerializable<ActivityDependency> {
    private String activity;
    private List<DependencyCondition> dependencyConditions;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ActivityDependency.class);

    public String activity() {
        return this.activity;
    }

    public ActivityDependency withActivity(String activity) {
        this.activity = activity;
        return this;
    }

    public List<DependencyCondition> dependencyConditions() {
        return this.dependencyConditions;
    }

    public ActivityDependency withDependencyConditions(List<DependencyCondition> dependencyConditions) {
        this.dependencyConditions = dependencyConditions;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ActivityDependency withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.activity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property activity in model ActivityDependency"));
        }
        if (this.dependencyConditions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dependencyConditions in model ActivityDependency"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activity", this.activity);
        jsonWriter.writeArrayField("dependencyConditions", this.dependencyConditions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ActivityDependency fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityDependency)jsonReader.readObject(reader -> {
            ActivityDependency deserializedActivityDependency = new ActivityDependency();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activity".equals(fieldName)) {
                    deserializedActivityDependency.activity = reader.getString();
                    continue;
                }
                if ("dependencyConditions".equals(fieldName)) {
                    List dependencyConditions;
                    deserializedActivityDependency.dependencyConditions = dependencyConditions = reader.readArray(reader1 -> DependencyCondition.fromString(reader1.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivityDependency.additionalProperties = additionalProperties;
            return deserializedActivityDependency;
        });
    }
}

