/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.DatasetResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetResource;

public final class DatasetResourceImpl
implements DatasetResource,
DatasetResource.Definition,
DatasetResource.Update {
    private DatasetResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String datasetName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public Dataset properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DatasetResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatasetResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public DatasetResource create() {
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatasetResource create(Context context) {
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    DatasetResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new DatasetResourceInner();
        this.serviceManager = serviceManager;
        this.datasetName = name;
        this.createIfMatch = null;
    }

    @Override
    public DatasetResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public DatasetResource apply() {
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatasetResource apply(Context context) {
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    DatasetResourceImpl(DatasetResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.datasetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "datasets");
    }

    @Override
    public DatasetResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().getWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatasetResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (DatasetResourceInner)((Object)this.serviceManager.serviceClient().getDatasets().getWithResponse(this.resourceGroupName, this.factoryName, this.datasetName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public DatasetResourceImpl withProperties(Dataset properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DatasetResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

