/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.CredentialOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import com.azure.resourcemanager.datafactory.implementation.CredentialResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.CredentialOperations;
import com.azure.resourcemanager.datafactory.models.CredentialResource;

public final class CredentialOperationsImpl
implements CredentialOperations {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialOperationsImpl.class);
    private final CredentialOperationsClient innerClient;
    private final DataFactoryManager serviceManager;

    public CredentialOperationsImpl(CredentialOperationsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CredentialResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<CredentialResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialResourceImpl((CredentialResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CredentialResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<CredentialResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialResourceImpl((CredentialResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<CredentialResource> getWithResponse(String resourceGroupName, String factoryName, String credentialName, String ifNoneMatch, Context context) {
        Response<CredentialResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, credentialName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CredentialResourceImpl((CredentialResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CredentialResource get(String resourceGroupName, String factoryName, String credentialName) {
        CredentialResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, credentialName);
        if (inner != null) {
            return new CredentialResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String credentialName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, credentialName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String credentialName) {
        this.serviceClient().delete(resourceGroupName, factoryName, credentialName);
    }

    @Override
    public CredentialResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        String localIfNoneMatch = null;
        return (CredentialResource)this.getWithResponse(resourceGroupName, factoryName, credentialName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<CredentialResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, credentialName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, credentialName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, credentialName, context);
    }

    private CredentialOperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public CredentialResourceImpl define(String name) {
        return new CredentialResourceImpl(name, this.manager());
    }
}

