/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebActivityMethod;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebActivityTypeProperties
implements JsonSerializable<WebActivityTypeProperties> {
    private WebActivityMethod method;
    private Object url;
    private Map<String, Object> headers;
    private Object body;
    private WebActivityAuthentication authentication;
    private Boolean disableCertValidation;
    private Object httpRequestTimeout;
    private Boolean turnOffAsync;
    private List<DatasetReference> datasets;
    private List<LinkedServiceReference> linkedServices;
    private IntegrationRuntimeReference connectVia;
    private static final ClientLogger LOGGER = new ClientLogger(WebActivityTypeProperties.class);

    public WebActivityMethod method() {
        return this.method;
    }

    public WebActivityTypeProperties withMethod(WebActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object url() {
        return this.url;
    }

    public WebActivityTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public WebActivityTypeProperties withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public WebActivityTypeProperties withBody(Object body) {
        this.body = body;
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.authentication;
    }

    public WebActivityTypeProperties withAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public Boolean disableCertValidation() {
        return this.disableCertValidation;
    }

    public WebActivityTypeProperties withDisableCertValidation(Boolean disableCertValidation) {
        this.disableCertValidation = disableCertValidation;
        return this;
    }

    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public WebActivityTypeProperties withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public Boolean turnOffAsync() {
        return this.turnOffAsync;
    }

    public WebActivityTypeProperties withTurnOffAsync(Boolean turnOffAsync) {
        this.turnOffAsync = turnOffAsync;
        return this;
    }

    public List<DatasetReference> datasets() {
        return this.datasets;
    }

    public WebActivityTypeProperties withDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    public List<LinkedServiceReference> linkedServices() {
        return this.linkedServices;
    }

    public WebActivityTypeProperties withLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.connectVia;
    }

    public WebActivityTypeProperties withConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public void validate() {
        if (this.method() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property method in model WebActivityTypeProperties"));
        }
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebActivityTypeProperties"));
        }
        if (this.authentication() != null) {
            this.authentication().validate();
        }
        if (this.datasets() != null) {
            this.datasets().forEach(e -> e.validate());
        }
        if (this.linkedServices() != null) {
            this.linkedServices().forEach(e -> e.validate());
        }
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeUntyped(element));
        if (this.body != null) {
            jsonWriter.writeUntypedField("body", this.body);
        }
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeBooleanField("disableCertValidation", this.disableCertValidation);
        if (this.httpRequestTimeout != null) {
            jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        }
        jsonWriter.writeBooleanField("turnOffAsync", this.turnOffAsync);
        jsonWriter.writeArrayField("datasets", this.datasets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedServices", this.linkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia);
        return jsonWriter.writeEndObject();
    }

    public static WebActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebActivityTypeProperties)jsonReader.readObject(reader -> {
            WebActivityTypeProperties deserializedWebActivityTypeProperties = new WebActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.method = WebActivityMethod.fromString(reader.getString());
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedWebActivityTypeProperties.headers = headers = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.body = reader.readUntyped();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.authentication = WebActivityAuthentication.fromJson(reader);
                    continue;
                }
                if ("disableCertValidation".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.disableCertValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if ("turnOffAsync".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.turnOffAsync = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("datasets".equals(fieldName)) {
                    List datasets;
                    deserializedWebActivityTypeProperties.datasets = datasets = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                if ("linkedServices".equals(fieldName)) {
                    List linkedServices;
                    deserializedWebActivityTypeProperties.linkedServices = linkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedWebActivityTypeProperties.connectVia = IntegrationRuntimeReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebActivityTypeProperties;
        });
    }
}

