/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SybaseAuthenticationType;
import java.io.IOException;

public final class SybaseLinkedServiceTypeProperties
implements JsonSerializable<SybaseLinkedServiceTypeProperties> {
    private Object server;
    private Object database;
    private Object schema;
    private SybaseAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SybaseLinkedServiceTypeProperties.class);

    public Object server() {
        return this.server;
    }

    public SybaseLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public SybaseLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object schema() {
        return this.schema;
    }

    public SybaseLinkedServiceTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    public SybaseAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SybaseLinkedServiceTypeProperties withAuthenticationType(SybaseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SybaseLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SybaseLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SybaseLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model SybaseLinkedServiceTypeProperties"));
        }
        if (this.database() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property database in model SybaseLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeUntypedField("database", this.database);
        if (this.schema != null) {
            jsonWriter.writeUntypedField("schema", this.schema);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SybaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SybaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SybaseLinkedServiceTypeProperties deserializedSybaseLinkedServiceTypeProperties = new SybaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.schema = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.authenticationType = SybaseAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSybaseLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSybaseLinkedServiceTypeProperties;
        });
    }
}

