/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SquareLinkedServiceTypeProperties
implements JsonSerializable<SquareLinkedServiceTypeProperties> {
    private Object connectionProperties;
    private Object host;
    private Object clientId;
    private SecretBase clientSecret;
    private Object redirectUri;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;

    public Object connectionProperties() {
        return this.connectionProperties;
    }

    public SquareLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object host() {
        return this.host;
    }

    public SquareLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public SquareLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public SquareLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object redirectUri() {
        return this.redirectUri;
    }

    public SquareLinkedServiceTypeProperties withRedirectUri(Object redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public SquareLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public SquareLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public SquareLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SquareLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionProperties != null) {
            jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
        }
        if (this.host != null) {
            jsonWriter.writeUntypedField("host", this.host);
        }
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.redirectUri != null) {
            jsonWriter.writeUntypedField("redirectUri", this.redirectUri);
        }
        if (this.useEncryptedEndpoints != null) {
            jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        }
        if (this.useHostVerification != null) {
            jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        }
        if (this.usePeerVerification != null) {
            jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SquareLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SquareLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SquareLinkedServiceTypeProperties deserializedSquareLinkedServiceTypeProperties = new SquareLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionProperties".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.connectionProperties = reader.readUntyped();
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("redirectUri".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.redirectUri = reader.readUntyped();
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSquareLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSquareLinkedServiceTypeProperties;
        });
    }
}

