/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RerunTumblingWindowTriggerTypeProperties
implements JsonSerializable<RerunTumblingWindowTriggerTypeProperties> {
    private Object parentTrigger;
    private OffsetDateTime requestedStartTime;
    private OffsetDateTime requestedEndTime;
    private int rerunConcurrency;
    private static final ClientLogger LOGGER = new ClientLogger(RerunTumblingWindowTriggerTypeProperties.class);

    public Object parentTrigger() {
        return this.parentTrigger;
    }

    public RerunTumblingWindowTriggerTypeProperties withParentTrigger(Object parentTrigger) {
        this.parentTrigger = parentTrigger;
        return this;
    }

    public OffsetDateTime requestedStartTime() {
        return this.requestedStartTime;
    }

    public RerunTumblingWindowTriggerTypeProperties withRequestedStartTime(OffsetDateTime requestedStartTime) {
        this.requestedStartTime = requestedStartTime;
        return this;
    }

    public OffsetDateTime requestedEndTime() {
        return this.requestedEndTime;
    }

    public RerunTumblingWindowTriggerTypeProperties withRequestedEndTime(OffsetDateTime requestedEndTime) {
        this.requestedEndTime = requestedEndTime;
        return this;
    }

    public int rerunConcurrency() {
        return this.rerunConcurrency;
    }

    public RerunTumblingWindowTriggerTypeProperties withRerunConcurrency(int rerunConcurrency) {
        this.rerunConcurrency = rerunConcurrency;
        return this;
    }

    public void validate() {
        if (this.parentTrigger() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parentTrigger in model RerunTumblingWindowTriggerTypeProperties"));
        }
        if (this.requestedStartTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requestedStartTime in model RerunTumblingWindowTriggerTypeProperties"));
        }
        if (this.requestedEndTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requestedEndTime in model RerunTumblingWindowTriggerTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("parentTrigger", this.parentTrigger);
        jsonWriter.writeStringField("requestedStartTime", this.requestedStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestedStartTime));
        jsonWriter.writeStringField("requestedEndTime", this.requestedEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestedEndTime));
        jsonWriter.writeIntField("rerunConcurrency", this.rerunConcurrency);
        return jsonWriter.writeEndObject();
    }

    public static RerunTumblingWindowTriggerTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RerunTumblingWindowTriggerTypeProperties)jsonReader.readObject(reader -> {
            RerunTumblingWindowTriggerTypeProperties deserializedRerunTumblingWindowTriggerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parentTrigger".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerTypeProperties.parentTrigger = reader.readUntyped();
                    continue;
                }
                if ("requestedStartTime".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerTypeProperties.requestedStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("requestedEndTime".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerTypeProperties.requestedEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("rerunConcurrency".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerTypeProperties.rerunConcurrency = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRerunTumblingWindowTriggerTypeProperties;
        });
    }
}

