/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class PostgreSqlV2LinkedServiceTypeProperties
implements JsonSerializable<PostgreSqlV2LinkedServiceTypeProperties> {
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object authenticationType;
    private Object sslMode;
    private Object schema;
    private Object pooling;
    private Object connectionTimeout;
    private Object commandTimeout;
    private Object trustServerCertificate;
    private Object sslCertificate;
    private Object sslKey;
    private Object sslPassword;
    private Object readBufferSize;
    private Object logParameters;
    private Object timezone;
    private Object encoding;
    private AzureKeyVaultSecretReference password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlV2LinkedServiceTypeProperties.class);

    public Object server() {
        return this.server;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object sslMode() {
        return this.sslMode;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object schema() {
        return this.schema;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    public Object pooling() {
        return this.pooling;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withPooling(Object pooling) {
        this.pooling = pooling;
        return this;
    }

    public Object connectionTimeout() {
        return this.connectionTimeout;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Object commandTimeout() {
        return this.commandTimeout;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public Object trustServerCertificate() {
        return this.trustServerCertificate;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public Object sslCertificate() {
        return this.sslCertificate;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withSslCertificate(Object sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    public Object sslKey() {
        return this.sslKey;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withSslKey(Object sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    public Object sslPassword() {
        return this.sslPassword;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withSslPassword(Object sslPassword) {
        this.sslPassword = sslPassword;
        return this;
    }

    public Object readBufferSize() {
        return this.readBufferSize;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withReadBufferSize(Object readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public Object logParameters() {
        return this.logParameters;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withLogParameters(Object logParameters) {
        this.logParameters = logParameters;
        return this;
    }

    public Object timezone() {
        return this.timezone;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withTimezone(Object timezone) {
        this.timezone = timezone;
        return this;
    }

    public Object encoding() {
        return this.encoding;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withEncoding(Object encoding) {
        this.encoding = encoding;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public PostgreSqlV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (this.database() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property database in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (this.sslMode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sslMode in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeUntypedField("database", this.database);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        jsonWriter.writeUntypedField("sslMode", this.sslMode);
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.schema != null) {
            jsonWriter.writeUntypedField("schema", this.schema);
        }
        if (this.pooling != null) {
            jsonWriter.writeUntypedField("pooling", this.pooling);
        }
        if (this.connectionTimeout != null) {
            jsonWriter.writeUntypedField("connectionTimeout", this.connectionTimeout);
        }
        if (this.commandTimeout != null) {
            jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
        }
        if (this.trustServerCertificate != null) {
            jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate);
        }
        if (this.sslCertificate != null) {
            jsonWriter.writeUntypedField("sslCertificate", this.sslCertificate);
        }
        if (this.sslKey != null) {
            jsonWriter.writeUntypedField("sslKey", this.sslKey);
        }
        if (this.sslPassword != null) {
            jsonWriter.writeUntypedField("sslPassword", this.sslPassword);
        }
        if (this.readBufferSize != null) {
            jsonWriter.writeUntypedField("readBufferSize", this.readBufferSize);
        }
        if (this.logParameters != null) {
            jsonWriter.writeUntypedField("logParameters", this.logParameters);
        }
        if (this.timezone != null) {
            jsonWriter.writeUntypedField("timezone", this.timezone);
        }
        if (this.encoding != null) {
            jsonWriter.writeUntypedField("encoding", this.encoding);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static PostgreSqlV2LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PostgreSqlV2LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            PostgreSqlV2LinkedServiceTypeProperties deserializedPostgreSqlV2LinkedServiceTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.sslMode = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.schema = reader.readUntyped();
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.pooling = reader.readUntyped();
                    continue;
                }
                if ("connectionTimeout".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.connectionTimeout = reader.readUntyped();
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.commandTimeout = reader.readUntyped();
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.trustServerCertificate = reader.readUntyped();
                    continue;
                }
                if ("sslCertificate".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.sslCertificate = reader.readUntyped();
                    continue;
                }
                if ("sslKey".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.sslKey = reader.readUntyped();
                    continue;
                }
                if ("sslPassword".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.sslPassword = reader.readUntyped();
                    continue;
                }
                if ("readBufferSize".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.readBufferSize = reader.readUntyped();
                    continue;
                }
                if ("logParameters".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.logParameters = reader.readUntyped();
                    continue;
                }
                if ("timezone".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.timezone = reader.readUntyped();
                    continue;
                }
                if ("encoding".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.encoding = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPostgreSqlV2LinkedServiceTypeProperties;
        });
    }
}

