/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PipelineRunInvokedBy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PipelineRunInner
implements JsonSerializable<PipelineRunInner> {
    private String runId;
    private String runGroupId;
    private Boolean isLatest;
    private String pipelineName;
    private Map<String, String> parameters;
    private Map<String, String> runDimensions;
    private PipelineRunInvokedBy invokedBy;
    private OffsetDateTime lastUpdated;
    private OffsetDateTime runStart;
    private OffsetDateTime runEnd;
    private Integer durationInMs;
    private String status;
    private String message;
    private Map<String, Object> additionalProperties;

    public String runId() {
        return this.runId;
    }

    public String runGroupId() {
        return this.runGroupId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Map<String, String> runDimensions() {
        return this.runDimensions;
    }

    public PipelineRunInvokedBy invokedBy() {
        return this.invokedBy;
    }

    public OffsetDateTime lastUpdated() {
        return this.lastUpdated;
    }

    public OffsetDateTime runStart() {
        return this.runStart;
    }

    public OffsetDateTime runEnd() {
        return this.runEnd;
    }

    public Integer durationInMs() {
        return this.durationInMs;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public PipelineRunInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.invokedBy() != null) {
            this.invokedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PipelineRunInner fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineRunInner)jsonReader.readObject(reader -> {
            PipelineRunInner deserializedPipelineRunInner = new PipelineRunInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runId".equals(fieldName)) {
                    deserializedPipelineRunInner.runId = reader.getString();
                    continue;
                }
                if ("runGroupId".equals(fieldName)) {
                    deserializedPipelineRunInner.runGroupId = reader.getString();
                    continue;
                }
                if ("isLatest".equals(fieldName)) {
                    deserializedPipelineRunInner.isLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pipelineName".equals(fieldName)) {
                    deserializedPipelineRunInner.pipelineName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPipelineRunInner.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("runDimensions".equals(fieldName)) {
                    Map runDimensions;
                    deserializedPipelineRunInner.runDimensions = runDimensions = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("invokedBy".equals(fieldName)) {
                    deserializedPipelineRunInner.invokedBy = PipelineRunInvokedBy.fromJson(reader);
                    continue;
                }
                if ("lastUpdated".equals(fieldName)) {
                    deserializedPipelineRunInner.lastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runStart".equals(fieldName)) {
                    deserializedPipelineRunInner.runStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runEnd".equals(fieldName)) {
                    deserializedPipelineRunInner.runEnd = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInMs".equals(fieldName)) {
                    deserializedPipelineRunInner.durationInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPipelineRunInner.status = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedPipelineRunInner.message = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPipelineRunInner.additionalProperties = additionalProperties;
            return deserializedPipelineRunInner;
        });
    }
}

