/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class OracleCloudStorageLinkedServiceTypeProperties
implements JsonSerializable<OracleCloudStorageLinkedServiceTypeProperties> {
    private Object accessKeyId;
    private SecretBase secretAccessKey;
    private Object serviceUrl;
    private String encryptedCredential;

    public Object accessKeyId() {
        return this.accessKeyId;
    }

    public OracleCloudStorageLinkedServiceTypeProperties withAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase secretAccessKey() {
        return this.secretAccessKey;
    }

    public OracleCloudStorageLinkedServiceTypeProperties withSecretAccessKey(SecretBase secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public Object serviceUrl() {
        return this.serviceUrl;
    }

    public OracleCloudStorageLinkedServiceTypeProperties withServiceUrl(Object serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public OracleCloudStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.secretAccessKey() != null) {
            this.secretAccessKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.accessKeyId != null) {
            jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
        }
        jsonWriter.writeJsonField("secretAccessKey", (JsonSerializable)this.secretAccessKey);
        if (this.serviceUrl != null) {
            jsonWriter.writeUntypedField("serviceUrl", this.serviceUrl);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static OracleCloudStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OracleCloudStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            OracleCloudStorageLinkedServiceTypeProperties deserializedOracleCloudStorageLinkedServiceTypeProperties = new OracleCloudStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessKeyId".equals(fieldName)) {
                    deserializedOracleCloudStorageLinkedServiceTypeProperties.accessKeyId = reader.readUntyped();
                    continue;
                }
                if ("secretAccessKey".equals(fieldName)) {
                    deserializedOracleCloudStorageLinkedServiceTypeProperties.secretAccessKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedOracleCloudStorageLinkedServiceTypeProperties.serviceUrl = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedOracleCloudStorageLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOracleCloudStorageLinkedServiceTypeProperties;
        });
    }
}

