/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class Office365LinkedServiceTypeProperties
implements JsonSerializable<Office365LinkedServiceTypeProperties> {
    private Object office365TenantId;
    private Object servicePrincipalTenantId;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(Office365LinkedServiceTypeProperties.class);

    public Object office365TenantId() {
        return this.office365TenantId;
    }

    public Office365LinkedServiceTypeProperties withOffice365TenantId(Object office365TenantId) {
        this.office365TenantId = office365TenantId;
        return this;
    }

    public Object servicePrincipalTenantId() {
        return this.servicePrincipalTenantId;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalTenantId(Object servicePrincipalTenantId) {
        this.servicePrincipalTenantId = servicePrincipalTenantId;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public Office365LinkedServiceTypeProperties withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public Office365LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.office365TenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property office365TenantId in model Office365LinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalTenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalTenantId in model Office365LinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalId in model Office365LinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property servicePrincipalKey in model Office365LinkedServiceTypeProperties"));
        }
        this.servicePrincipalKey().validate();
        if (this.servicePrincipalEmbeddedCert() != null) {
            this.servicePrincipalEmbeddedCert().validate();
        }
        if (this.servicePrincipalEmbeddedCertPassword() != null) {
            this.servicePrincipalEmbeddedCertPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("office365TenantId", this.office365TenantId);
        jsonWriter.writeUntypedField("servicePrincipalTenantId", this.servicePrincipalTenantId);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static Office365LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (Office365LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            Office365LinkedServiceTypeProperties deserializedOffice365LinkedServiceTypeProperties = new Office365LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("office365TenantId".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.office365TenantId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalTenantId".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalTenantId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedOffice365LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOffice365LinkedServiceTypeProperties;
        });
    }
}

