/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class MySqlLinkedServiceTypeProperties
implements JsonSerializable<MySqlLinkedServiceTypeProperties> {
    private Object driverVersion;
    private Object connectionString;
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object useSystemTrustStore;
    private AzureKeyVaultSecretReference password;
    private String encryptedCredential;
    private Object allowZeroDateTime;
    private Object connectionTimeout;
    private Object convertZeroDateTime;
    private Object guidFormat;
    private Object sslCert;
    private Object sslKey;
    private Object treatTinyAsBoolean;

    public Object driverVersion() {
        return this.driverVersion;
    }

    public MySqlLinkedServiceTypeProperties withDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    public Object connectionString() {
        return this.connectionString;
    }

    public MySqlLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public MySqlLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public MySqlLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public MySqlLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public MySqlLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object sslMode() {
        return this.sslMode;
    }

    public MySqlLinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public MySqlLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public MySqlLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public MySqlLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object allowZeroDateTime() {
        return this.allowZeroDateTime;
    }

    public MySqlLinkedServiceTypeProperties withAllowZeroDateTime(Object allowZeroDateTime) {
        this.allowZeroDateTime = allowZeroDateTime;
        return this;
    }

    public Object connectionTimeout() {
        return this.connectionTimeout;
    }

    public MySqlLinkedServiceTypeProperties withConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Object convertZeroDateTime() {
        return this.convertZeroDateTime;
    }

    public MySqlLinkedServiceTypeProperties withConvertZeroDateTime(Object convertZeroDateTime) {
        this.convertZeroDateTime = convertZeroDateTime;
        return this;
    }

    public Object guidFormat() {
        return this.guidFormat;
    }

    public MySqlLinkedServiceTypeProperties withGuidFormat(Object guidFormat) {
        this.guidFormat = guidFormat;
        return this;
    }

    public Object sslCert() {
        return this.sslCert;
    }

    public MySqlLinkedServiceTypeProperties withSslCert(Object sslCert) {
        this.sslCert = sslCert;
        return this;
    }

    public Object sslKey() {
        return this.sslKey;
    }

    public MySqlLinkedServiceTypeProperties withSslKey(Object sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    public Object treatTinyAsBoolean() {
        return this.treatTinyAsBoolean;
    }

    public MySqlLinkedServiceTypeProperties withTreatTinyAsBoolean(Object treatTinyAsBoolean) {
        this.treatTinyAsBoolean = treatTinyAsBoolean;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.driverVersion != null) {
            jsonWriter.writeUntypedField("driverVersion", this.driverVersion);
        }
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        if (this.server != null) {
            jsonWriter.writeUntypedField("server", this.server);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        if (this.database != null) {
            jsonWriter.writeUntypedField("database", this.database);
        }
        if (this.sslMode != null) {
            jsonWriter.writeUntypedField("sslMode", this.sslMode);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        if (this.allowZeroDateTime != null) {
            jsonWriter.writeUntypedField("allowZeroDateTime", this.allowZeroDateTime);
        }
        if (this.connectionTimeout != null) {
            jsonWriter.writeUntypedField("connectionTimeout", this.connectionTimeout);
        }
        if (this.convertZeroDateTime != null) {
            jsonWriter.writeUntypedField("convertZeroDateTime", this.convertZeroDateTime);
        }
        if (this.guidFormat != null) {
            jsonWriter.writeUntypedField("guidFormat", this.guidFormat);
        }
        if (this.sslCert != null) {
            jsonWriter.writeUntypedField("sslCert", this.sslCert);
        }
        if (this.sslKey != null) {
            jsonWriter.writeUntypedField("sslKey", this.sslKey);
        }
        if (this.treatTinyAsBoolean != null) {
            jsonWriter.writeUntypedField("treatTinyAsBoolean", this.treatTinyAsBoolean);
        }
        return jsonWriter.writeEndObject();
    }

    public static MySqlLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MySqlLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            MySqlLinkedServiceTypeProperties deserializedMySqlLinkedServiceTypeProperties = new MySqlLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("driverVersion".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.driverVersion = reader.readUntyped();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.sslMode = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("allowZeroDateTime".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.allowZeroDateTime = reader.readUntyped();
                    continue;
                }
                if ("connectionTimeout".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.connectionTimeout = reader.readUntyped();
                    continue;
                }
                if ("convertZeroDateTime".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.convertZeroDateTime = reader.readUntyped();
                    continue;
                }
                if ("guidFormat".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.guidFormat = reader.readUntyped();
                    continue;
                }
                if ("sslCert".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.sslCert = reader.readUntyped();
                    continue;
                }
                if ("sslKey".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.sslKey = reader.readUntyped();
                    continue;
                }
                if ("treatTinyAsBoolean".equals(fieldName)) {
                    deserializedMySqlLinkedServiceTypeProperties.treatTinyAsBoolean = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMySqlLinkedServiceTypeProperties;
        });
    }
}

