/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeComputeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeCustomerVirtualNetwork;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisProperties;
import java.io.IOException;

public final class ManagedIntegrationRuntimeTypeProperties
implements JsonSerializable<ManagedIntegrationRuntimeTypeProperties> {
    private IntegrationRuntimeComputeProperties computeProperties;
    private IntegrationRuntimeSsisProperties ssisProperties;
    private IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork;

    public IntegrationRuntimeComputeProperties computeProperties() {
        return this.computeProperties;
    }

    public ManagedIntegrationRuntimeTypeProperties withComputeProperties(IntegrationRuntimeComputeProperties computeProperties) {
        this.computeProperties = computeProperties;
        return this;
    }

    public IntegrationRuntimeSsisProperties ssisProperties() {
        return this.ssisProperties;
    }

    public ManagedIntegrationRuntimeTypeProperties withSsisProperties(IntegrationRuntimeSsisProperties ssisProperties) {
        this.ssisProperties = ssisProperties;
        return this;
    }

    public IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork() {
        return this.customerVirtualNetwork;
    }

    public ManagedIntegrationRuntimeTypeProperties withCustomerVirtualNetwork(IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork) {
        this.customerVirtualNetwork = customerVirtualNetwork;
        return this;
    }

    public void validate() {
        if (this.computeProperties() != null) {
            this.computeProperties().validate();
        }
        if (this.ssisProperties() != null) {
            this.ssisProperties().validate();
        }
        if (this.customerVirtualNetwork() != null) {
            this.customerVirtualNetwork().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("computeProperties", (JsonSerializable)this.computeProperties);
        jsonWriter.writeJsonField("ssisProperties", (JsonSerializable)this.ssisProperties);
        jsonWriter.writeJsonField("customerVirtualNetwork", (JsonSerializable)this.customerVirtualNetwork);
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntimeTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntimeTypeProperties)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntimeTypeProperties deserializedManagedIntegrationRuntimeTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computeProperties".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeTypeProperties.computeProperties = IntegrationRuntimeComputeProperties.fromJson(reader);
                    continue;
                }
                if ("ssisProperties".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeTypeProperties.ssisProperties = IntegrationRuntimeSsisProperties.fromJson(reader);
                    continue;
                }
                if ("customerVirtualNetwork".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeTypeProperties.customerVirtualNetwork = IntegrationRuntimeCustomerVirtualNetwork.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedIntegrationRuntimeTypeProperties;
        });
    }
}

