/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HDInsightSparkActivityTypeProperties
implements JsonSerializable<HDInsightSparkActivityTypeProperties> {
    private Object rootPath;
    private Object entryFilePath;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private LinkedServiceReference sparkJobLinkedService;
    private String className;
    private Object proxyUser;
    private Map<String, Object> sparkConfig;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightSparkActivityTypeProperties.class);

    public Object rootPath() {
        return this.rootPath;
    }

    public HDInsightSparkActivityTypeProperties withRootPath(Object rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public Object entryFilePath() {
        return this.entryFilePath;
    }

    public HDInsightSparkActivityTypeProperties withEntryFilePath(Object entryFilePath) {
        this.entryFilePath = entryFilePath;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightSparkActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightSparkActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public LinkedServiceReference sparkJobLinkedService() {
        return this.sparkJobLinkedService;
    }

    public HDInsightSparkActivityTypeProperties withSparkJobLinkedService(LinkedServiceReference sparkJobLinkedService) {
        this.sparkJobLinkedService = sparkJobLinkedService;
        return this;
    }

    public String className() {
        return this.className;
    }

    public HDInsightSparkActivityTypeProperties withClassName(String className) {
        this.className = className;
        return this;
    }

    public Object proxyUser() {
        return this.proxyUser;
    }

    public HDInsightSparkActivityTypeProperties withProxyUser(Object proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public Map<String, Object> sparkConfig() {
        return this.sparkConfig;
    }

    public HDInsightSparkActivityTypeProperties withSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    public void validate() {
        if (this.rootPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rootPath in model HDInsightSparkActivityTypeProperties"));
        }
        if (this.entryFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property entryFilePath in model HDInsightSparkActivityTypeProperties"));
        }
        if (this.sparkJobLinkedService() != null) {
            this.sparkJobLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("rootPath", this.rootPath);
        jsonWriter.writeUntypedField("entryFilePath", this.entryFilePath);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
        jsonWriter.writeJsonField("sparkJobLinkedService", (JsonSerializable)this.sparkJobLinkedService);
        jsonWriter.writeStringField("className", this.className);
        if (this.proxyUser != null) {
            jsonWriter.writeUntypedField("proxyUser", this.proxyUser);
        }
        jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static HDInsightSparkActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightSparkActivityTypeProperties)jsonReader.readObject(reader -> {
            HDInsightSparkActivityTypeProperties deserializedHDInsightSparkActivityTypeProperties = new HDInsightSparkActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rootPath".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.rootPath = reader.readUntyped();
                    continue;
                }
                if ("entryFilePath".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.entryFilePath = reader.readUntyped();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedHDInsightSparkActivityTypeProperties.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("getDebugInfo".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                    continue;
                }
                if ("sparkJobLinkedService".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.sparkJobLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("className".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.className = reader.getString();
                    continue;
                }
                if ("proxyUser".equals(fieldName)) {
                    deserializedHDInsightSparkActivityTypeProperties.proxyUser = reader.readUntyped();
                    continue;
                }
                if ("sparkConfig".equals(fieldName)) {
                    Map sparkConfig;
                    deserializedHDInsightSparkActivityTypeProperties.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightSparkActivityTypeProperties;
        });
    }
}

