/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CustomActivityReferenceObject;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.Map;

public final class CustomActivityTypeProperties
implements JsonSerializable<CustomActivityTypeProperties> {
    private Object command;
    private LinkedServiceReference resourceLinkedService;
    private Object folderPath;
    private CustomActivityReferenceObject referenceObjects;
    private Map<String, Object> extendedProperties;
    private Object retentionTimeInDays;
    private Object autoUserSpecification;
    private static final ClientLogger LOGGER = new ClientLogger(CustomActivityTypeProperties.class);

    public Object command() {
        return this.command;
    }

    public CustomActivityTypeProperties withCommand(Object command) {
        this.command = command;
        return this;
    }

    public LinkedServiceReference resourceLinkedService() {
        return this.resourceLinkedService;
    }

    public CustomActivityTypeProperties withResourceLinkedService(LinkedServiceReference resourceLinkedService) {
        this.resourceLinkedService = resourceLinkedService;
        return this;
    }

    public Object folderPath() {
        return this.folderPath;
    }

    public CustomActivityTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public CustomActivityReferenceObject referenceObjects() {
        return this.referenceObjects;
    }

    public CustomActivityTypeProperties withReferenceObjects(CustomActivityReferenceObject referenceObjects) {
        this.referenceObjects = referenceObjects;
        return this;
    }

    public Map<String, Object> extendedProperties() {
        return this.extendedProperties;
    }

    public CustomActivityTypeProperties withExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public Object retentionTimeInDays() {
        return this.retentionTimeInDays;
    }

    public CustomActivityTypeProperties withRetentionTimeInDays(Object retentionTimeInDays) {
        this.retentionTimeInDays = retentionTimeInDays;
        return this;
    }

    public Object autoUserSpecification() {
        return this.autoUserSpecification;
    }

    public CustomActivityTypeProperties withAutoUserSpecification(Object autoUserSpecification) {
        this.autoUserSpecification = autoUserSpecification;
        return this;
    }

    public void validate() {
        if (this.command() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property command in model CustomActivityTypeProperties"));
        }
        if (this.resourceLinkedService() != null) {
            this.resourceLinkedService().validate();
        }
        if (this.referenceObjects() != null) {
            this.referenceObjects().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("command", this.command);
        jsonWriter.writeJsonField("resourceLinkedService", (JsonSerializable)this.resourceLinkedService);
        if (this.folderPath != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath);
        }
        jsonWriter.writeJsonField("referenceObjects", (JsonSerializable)this.referenceObjects);
        jsonWriter.writeMapField("extendedProperties", this.extendedProperties, (writer, element) -> writer.writeUntyped(element));
        if (this.retentionTimeInDays != null) {
            jsonWriter.writeUntypedField("retentionTimeInDays", this.retentionTimeInDays);
        }
        if (this.autoUserSpecification != null) {
            jsonWriter.writeUntypedField("autoUserSpecification", this.autoUserSpecification);
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CustomActivityTypeProperties)jsonReader.readObject(reader -> {
            CustomActivityTypeProperties deserializedCustomActivityTypeProperties = new CustomActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("command".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.command = reader.readUntyped();
                    continue;
                }
                if ("resourceLinkedService".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.resourceLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.folderPath = reader.readUntyped();
                    continue;
                }
                if ("referenceObjects".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.referenceObjects = CustomActivityReferenceObject.fromJson(reader);
                    continue;
                }
                if ("extendedProperties".equals(fieldName)) {
                    Map extendedProperties;
                    deserializedCustomActivityTypeProperties.extendedProperties = extendedProperties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("retentionTimeInDays".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.retentionTimeInDays = reader.readUntyped();
                    continue;
                }
                if ("autoUserSpecification".equals(fieldName)) {
                    deserializedCustomActivityTypeProperties.autoUserSpecification = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomActivityTypeProperties;
        });
    }
}

