/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class AzureMLUpdateResourceActivityTypeProperties
implements JsonSerializable<AzureMLUpdateResourceActivityTypeProperties> {
    private Object trainedModelName;
    private LinkedServiceReference trainedModelLinkedServiceName;
    private Object trainedModelFilePath;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLUpdateResourceActivityTypeProperties.class);

    public Object trainedModelName() {
        return this.trainedModelName;
    }

    public AzureMLUpdateResourceActivityTypeProperties withTrainedModelName(Object trainedModelName) {
        this.trainedModelName = trainedModelName;
        return this;
    }

    public LinkedServiceReference trainedModelLinkedServiceName() {
        return this.trainedModelLinkedServiceName;
    }

    public AzureMLUpdateResourceActivityTypeProperties withTrainedModelLinkedServiceName(LinkedServiceReference trainedModelLinkedServiceName) {
        this.trainedModelLinkedServiceName = trainedModelLinkedServiceName;
        return this;
    }

    public Object trainedModelFilePath() {
        return this.trainedModelFilePath;
    }

    public AzureMLUpdateResourceActivityTypeProperties withTrainedModelFilePath(Object trainedModelFilePath) {
        this.trainedModelFilePath = trainedModelFilePath;
        return this;
    }

    public void validate() {
        if (this.trainedModelName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property trainedModelName in model AzureMLUpdateResourceActivityTypeProperties"));
        }
        if (this.trainedModelLinkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property trainedModelLinkedServiceName in model AzureMLUpdateResourceActivityTypeProperties"));
        }
        this.trainedModelLinkedServiceName().validate();
        if (this.trainedModelFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property trainedModelFilePath in model AzureMLUpdateResourceActivityTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("trainedModelName", this.trainedModelName);
        jsonWriter.writeJsonField("trainedModelLinkedServiceName", (JsonSerializable)this.trainedModelLinkedServiceName);
        jsonWriter.writeUntypedField("trainedModelFilePath", this.trainedModelFilePath);
        return jsonWriter.writeEndObject();
    }

    public static AzureMLUpdateResourceActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLUpdateResourceActivityTypeProperties)jsonReader.readObject(reader -> {
            AzureMLUpdateResourceActivityTypeProperties deserializedAzureMLUpdateResourceActivityTypeProperties = new AzureMLUpdateResourceActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trainedModelName".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivityTypeProperties.trainedModelName = reader.readUntyped();
                    continue;
                }
                if ("trainedModelLinkedServiceName".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivityTypeProperties.trainedModelLinkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("trainedModelFilePath".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivityTypeProperties.trainedModelFilePath = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMLUpdateResourceActivityTypeProperties;
        });
    }
}

