/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class AvroDatasetTypeProperties
implements JsonSerializable<AvroDatasetTypeProperties> {
    private DatasetLocation location;
    private Object avroCompressionCodec;
    private Integer avroCompressionLevel;
    private static final ClientLogger LOGGER = new ClientLogger(AvroDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public AvroDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object avroCompressionCodec() {
        return this.avroCompressionCodec;
    }

    public AvroDatasetTypeProperties withAvroCompressionCodec(Object avroCompressionCodec) {
        this.avroCompressionCodec = avroCompressionCodec;
        return this;
    }

    public Integer avroCompressionLevel() {
        return this.avroCompressionLevel;
    }

    public AvroDatasetTypeProperties withAvroCompressionLevel(Integer avroCompressionLevel) {
        this.avroCompressionLevel = avroCompressionLevel;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model AvroDatasetTypeProperties"));
        }
        this.location().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        if (this.avroCompressionCodec != null) {
            jsonWriter.writeUntypedField("avroCompressionCodec", this.avroCompressionCodec);
        }
        jsonWriter.writeNumberField("avroCompressionLevel", (Number)this.avroCompressionLevel);
        return jsonWriter.writeEndObject();
    }

    public static AvroDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AvroDatasetTypeProperties)jsonReader.readObject(reader -> {
            AvroDatasetTypeProperties deserializedAvroDatasetTypeProperties = new AvroDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedAvroDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("avroCompressionCodec".equals(fieldName)) {
                    deserializedAvroDatasetTypeProperties.avroCompressionCodec = reader.readUntyped();
                    continue;
                }
                if ("avroCompressionLevel".equals(fieldName)) {
                    deserializedAvroDatasetTypeProperties.avroCompressionLevel = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvroDatasetTypeProperties;
        });
    }
}

