/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AppFiguresLinkedServiceTypeProperties
implements JsonSerializable<AppFiguresLinkedServiceTypeProperties> {
    private Object username;
    private SecretBase password;
    private SecretBase clientKey;
    private static final ClientLogger LOGGER = new ClientLogger(AppFiguresLinkedServiceTypeProperties.class);

    public Object username() {
        return this.username;
    }

    public AppFiguresLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public AppFiguresLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase clientKey() {
        return this.clientKey;
    }

    public AppFiguresLinkedServiceTypeProperties withClientKey(SecretBase clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model AppFiguresLinkedServiceTypeProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model AppFiguresLinkedServiceTypeProperties"));
        }
        this.password().validate();
        if (this.clientKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientKey in model AppFiguresLinkedServiceTypeProperties"));
        }
        this.clientKey().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeJsonField("clientKey", (JsonSerializable)this.clientKey);
        return jsonWriter.writeEndObject();
    }

    public static AppFiguresLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AppFiguresLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AppFiguresLinkedServiceTypeProperties deserializedAppFiguresLinkedServiceTypeProperties = new AppFiguresLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedAppFiguresLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAppFiguresLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clientKey".equals(fieldName)) {
                    deserializedAppFiguresLinkedServiceTypeProperties.clientKey = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppFiguresLinkedServiceTypeProperties;
        });
    }
}

