/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;

public final class AmazonS3DatasetTypeProperties
implements JsonSerializable<AmazonS3DatasetTypeProperties> {
    private Object bucketName;
    private Object key;
    private Object prefix;
    private Object version;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private DatasetCompression compression;
    private static final ClientLogger LOGGER = new ClientLogger(AmazonS3DatasetTypeProperties.class);

    public Object bucketName() {
        return this.bucketName;
    }

    public AmazonS3DatasetTypeProperties withBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object key() {
        return this.key;
    }

    public AmazonS3DatasetTypeProperties withKey(Object key) {
        this.key = key;
        return this;
    }

    public Object prefix() {
        return this.prefix;
    }

    public AmazonS3DatasetTypeProperties withPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public Object version() {
        return this.version;
    }

    public AmazonS3DatasetTypeProperties withVersion(Object version) {
        this.version = version;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AmazonS3DatasetTypeProperties withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AmazonS3DatasetTypeProperties withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat format() {
        return this.format;
    }

    public AmazonS3DatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public AmazonS3DatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.bucketName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bucketName in model AmazonS3DatasetTypeProperties"));
        }
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("bucketName", this.bucketName);
        if (this.key != null) {
            jsonWriter.writeUntypedField("key", this.key);
        }
        if (this.prefix != null) {
            jsonWriter.writeUntypedField("prefix", this.prefix);
        }
        if (this.version != null) {
            jsonWriter.writeUntypedField("version", this.version);
        }
        if (this.modifiedDatetimeStart != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        }
        if (this.modifiedDatetimeEnd != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        }
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3DatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3DatasetTypeProperties)jsonReader.readObject(reader -> {
            AmazonS3DatasetTypeProperties deserializedAmazonS3DatasetTypeProperties = new AmazonS3DatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bucketName".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.bucketName = reader.readUntyped();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.key = reader.readUntyped();
                    continue;
                }
                if ("prefix".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.prefix = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.version = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.format = DatasetStorageFormat.fromJson(reader);
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedAmazonS3DatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonS3DatasetTypeProperties;
        });
    }
}

