/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class InitContainerDefinition {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(InitContainerDefinition.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.image")
    private String image;
    @JsonProperty(value="properties.command")
    private List<String> command;
    @JsonProperty(value="properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private InitContainerPropertiesDefinitionInstanceView instanceView;
    @JsonProperty(value="properties.volumeMounts")
    private List<VolumeMount> volumeMounts;

    public String name() {
        return this.name;
    }

    public InitContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public String image() {
        return this.image;
    }

    public InitContainerDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public InitContainerDefinition withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public InitContainerDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.instanceView;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public InitContainerDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model InitContainerDefinition"));
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
    }
}

