/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.HttpHeaders;
import com.azure.resourcemanager.containerinstance.models.Scheme;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ContainerHttpGet {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerHttpGet.class);
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="port", required=true)
    private int port;
    @JsonProperty(value="scheme")
    private Scheme scheme;
    @JsonProperty(value="httpHeaders")
    private HttpHeaders httpHeaders;

    public String path() {
        return this.path;
    }

    public ContainerHttpGet withPath(String path) {
        this.path = path;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ContainerHttpGet withPort(int port) {
        this.port = port;
        return this;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public ContainerHttpGet withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpHeaders httpHeaders() {
        return this.httpHeaders;
    }

    public ContainerHttpGet withHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public void validate() {
        if (this.httpHeaders() != null) {
            this.httpHeaders().validate();
        }
    }
}

